const { contextBridge, ipcRenderer } = require('electron');

// Expune API-uri sigure pentru controlul ferestrei
contextBridge.exposeInMainWorld('electronAPI', {
  closeWindow: () => ipcRenderer.send('window-close'),
  minimizeWindow: () => ipcRenderer.send('window-minimize'),
  maximizeWindow: () => ipcRenderer.send('window-maximize'),
  wifiGetStatus: () => ipcRenderer.invoke('wifi-get-status'),
  wifiGetSSID: () => ipcRenderer.invoke('wifi-get-ssid'),
  wifiToggle: (enabled) => ipcRenderer.invoke('wifi-toggle', enabled),
  wifiGetNetworks: () => ipcRenderer.invoke('wifi-get-networks'),
  wifiConnect: (ssid, password) => ipcRenderer.invoke('wifi-connect', ssid, password),
  wifiForgetNetwork: (ssid) => ipcRenderer.invoke('wifi-forget-network', ssid),
  bluetoothGetStatus: () => ipcRenderer.invoke('bluetooth-get-status'),
  bluetoothToggle: (enabled) => ipcRenderer.invoke('bluetooth-toggle', enabled),
  bluetoothGetDeviceName: () => ipcRenderer.invoke('bluetooth-get-device-name'),
  bluetoothGetDevices: () => ipcRenderer.invoke('bluetooth-get-devices'),
  bluetoothScanDevices: () => ipcRenderer.invoke('bluetooth-scan-devices'),
  bluetoothConnect: (macAddress) => ipcRenderer.invoke('bluetooth-connect', macAddress),
  bluetoothDisconnect: (macAddress) => ipcRenderer.invoke('bluetooth-disconnect', macAddress),
  getActiveConnections: () => ipcRenderer.invoke('get-active-connections'),
  getRfkillStatus: () => ipcRenderer.invoke('get-rfkill-status'),
  setRfkillState: (type, id, enabled) => ipcRenderer.invoke('set-rfkill-state', type, id, enabled),
  getBatteryInfo: () => ipcRenderer.invoke('get-battery-info'),
  getLowPowerMode: () => ipcRenderer.invoke('get-low-power-mode'),
  setLowPowerMode: (enabled) => ipcRenderer.invoke('set-low-power-mode', enabled),
  getBatteryHealth: () => ipcRenderer.invoke('get-battery-health'),
  getBatteryUsageData: (period) => ipcRenderer.invoke('get-battery-usage-data', period),
  getSystemInfo: () => ipcRenderer.invoke('get-system-info'),
  getDisplays: () => ipcRenderer.invoke('get-displays'),
  getStorage: () => ipcRenderer.invoke('get-storage'),
  getAvailableUpdates: () => ipcRenderer.invoke('get-available-updates'),
  updateSystem: (password) => ipcRenderer.invoke('update-system', password),
  scheduleUpdate: (password) => ipcRenderer.invoke('schedule-update', password),
  getInstalledSystemInfo: () => ipcRenderer.invoke('get-installed-system-info'),
  getStorageInfo: () => ipcRenderer.invoke('get-storage-info'),
  getStorageAnalysis: () => ipcRenderer.invoke('get-storage-analysis'),
  openKWallet: () => ipcRenderer.invoke('open-kwallet'),
  getNtpStatus: () => ipcRenderer.invoke('get-ntp-status'),
  setNtpStatus: (enabled) => ipcRenderer.invoke('set-ntp-status', enabled),
  setDateTime: (date, time) => ipcRenderer.invoke('set-date-time', date, time),
  getTimezones: () => ipcRenderer.invoke('get-timezones'),
  getCurrentTimezone: () => ipcRenderer.invoke('get-current-timezone'),
  setTimezone: (timezone) => ipcRenderer.invoke('set-timezone', timezone),
  getAutostartItems: () => ipcRenderer.invoke('get-autostart-items'),
  removeAutostartItem: (fileName) => ipcRenderer.invoke('remove-autostart-item', fileName),
  addAutostartItem: () => ipcRenderer.invoke('add-autostart-item'),
  getBootEntries: () => ipcRenderer.invoke('get-boot-entries'),
  setBootEntry: (bootId, password) => ipcRenderer.invoke('set-boot-entry', bootId, password),
  rebootSystem: (password) => ipcRenderer.invoke('reboot-system', password),
  getBrightness: (displayName) => ipcRenderer.invoke('get-brightness', displayName),
  setBrightness: (brightness, displayName) => ipcRenderer.invoke('set-brightness', brightness, displayName),
  setDisplayEnabled: (displayName, enabled, modeId) => ipcRenderer.invoke('set-display-enabled', displayName, enabled, modeId),
  setDisplayPrimary: (displayName) => ipcRenderer.invoke('set-display-primary', displayName),
  setDisplayResolution: (displayName, resolutionType) => ipcRenderer.invoke('set-display-resolution', displayName, resolutionType),
  getCurrentWallpaper: () => ipcRenderer.invoke('get-current-wallpaper'),
  getWallpapers: () => ipcRenderer.invoke('get-wallpapers'),
  setWallpaper: (wallpaperPath) => ipcRenderer.invoke('set-wallpaper', wallpaperPath),
  browseWallpaper: (theme) => ipcRenderer.invoke('browse-wallpaper', theme),
  setWallpaperFillMode: (fillMode) => ipcRenderer.invoke('set-wallpaper-fill-mode', fillMode),
  getWallpaperThumbnail: (imagePath, size) => ipcRenderer.invoke('get-wallpaper-thumbnail', imagePath, size),
  getWallpaperThumbnailsBatch: (paths, size) => ipcRenderer.invoke('get-wallpaper-thumbnails-batch', paths, size),
  openWallpaperFolder: (folderPath) => ipcRenderer.invoke('open-wallpaper-folder', folderPath),
  getAudioOutputs: () => ipcRenderer.invoke('get-audio-outputs'),
  getAudioInputs: () => ipcRenderer.invoke('get-audio-inputs'),
  getOutputVolume: () => ipcRenderer.invoke('get-output-volume'),
  getInputVolume: () => ipcRenderer.invoke('get-input-volume'),
  setOutputVolume: (volume) => ipcRenderer.invoke('set-output-volume', volume),
  setInputVolume: (volume) => ipcRenderer.invoke('set-input-volume', volume),
  setOutputDevice: (deviceIndex) => ipcRenderer.invoke('set-output-device', deviceIndex),
  setInputDevice: (deviceIndex) => ipcRenderer.invoke('set-input-device', deviceIndex),
  getCurrentOutputDevice: () => ipcRenderer.invoke('get-current-output-device'),
  getCurrentInputDevice: () => ipcRenderer.invoke('get-current-input-device'),
  getBatteryTimeout: () => ipcRenderer.invoke('get-battery-timeout'),
  getAcTimeout: () => ipcRenderer.invoke('get-ac-timeout'),
  getLockDelay: () => ipcRenderer.invoke('get-lock-delay'),
  setBatteryTimeout: (timeoutSeconds) => ipcRenderer.invoke('set-battery-timeout', timeoutSeconds),
  setAcTimeout: (timeoutSeconds) => ipcRenderer.invoke('set-ac-timeout', timeoutSeconds),
  setLockDelay: (delaySeconds) => ipcRenderer.invoke('set-lock-delay', delaySeconds),
  getRequireApps: () => ipcRenderer.invoke('get-require-apps'),
  allowRequireApp: (filePath, allowAction) => ipcRenderer.invoke('allow-require-app', filePath, allowAction),
  denyRequireApp: (filePath) => ipcRenderer.invoke('deny-require-app', filePath),
  openExternalLink: (url) => ipcRenderer.invoke('open-external-link', url),
      changePassword: (oldPassword, newPassword) => ipcRenderer.invoke('change-password', oldPassword, newPassword),
      updateUserPassword: (oldPassword, newPassword) => ipcRenderer.invoke('update-user-password', oldPassword, newPassword),
  checkFingerprintDevice: () => ipcRenderer.invoke('check-fingerprint-device'),
  listFingerprints: () => ipcRenderer.invoke('list-fingerprints'),
  deleteFingerprint: (username, finger) => ipcRenderer.invoke('delete-fingerprint', username, finger),
  enrollFingerprint: (finger) => ipcRenderer.invoke('enroll-fingerprint', finger),
  onEnrollFingerprintOutput: (callback) => {
    ipcRenderer.on('enroll-fingerprint-output', (event, data) => callback(data));
  },
  removeEnrollFingerprintOutput: () => {
    ipcRenderer.removeAllListeners('enroll-fingerprint-output');
  },
  getUsers: () => ipcRenderer.invoke('get-users'),
  getAutologinStatus: () => ipcRenderer.invoke('get-autologin-status'),
  setAutologin: (enabled) => ipcRenderer.invoke('set-autologin', enabled),
  getKeyboardSettings: () => ipcRenderer.invoke('get-keyboard-settings'),
  setKeyRepeat: (enabled) => ipcRenderer.invoke('set-key-repeat', enabled),
  setKeyRepeatRate: (delay, rate) => ipcRenderer.invoke('set-key-repeat-rate', delay, rate),
  setKeyboardLayout: (layout) => ipcRenderer.invoke('set-keyboard-layout', layout),
  getTrackpadSettings: () => ipcRenderer.invoke('get-trackpad-settings'),
  getTouchpadConfig: () => ipcRenderer.invoke('get-touchpad-config'),
  setTouchpadConfig: (config) => ipcRenderer.invoke('set-touchpad-config', config),
  setTapToClick: (enabled) => ipcRenderer.invoke('set-tap-to-click', enabled),
  setNaturalScrolling: (enabled) => ipcRenderer.invoke('set-natural-scrolling', enabled),
  setTwoFingerScrolling: (enabled) => ipcRenderer.invoke('set-two-finger-scrolling', enabled),
  setTrackpadSpeed: (speed) => ipcRenderer.invoke('set-trackpad-speed', speed),
  modulesList: () => ipcRenderer.invoke('modules-list'),
  moduleReadFile: (moduleId, filePath) => ipcRenderer.invoke('module-read-file', moduleId, filePath),
  checkPearIdState: () => ipcRenderer.invoke('check-pearid-state'),
  checkPearIdLock: () => ipcRenderer.invoke('check-pearid-lock'),
  getUserInfo: () => ipcRenderer.invoke('get-user-info'),
  getUserAvatar: () => ipcRenderer.invoke('get-user-avatar'),
  getUserDevices: () => ipcRenderer.invoke('get-user-devices'),
  signOut: (password) => ipcRenderer.invoke('sign-out', password),
  getUserBirthdate: () => ipcRenderer.invoke('get-user-birthdate'),
  updateUserInfo: (firstName, lastName) => ipcRenderer.invoke('update-user-info', firstName, lastName),
  getUserPhone: () => ipcRenderer.invoke('get-user-phone'),
  getUserCountry: () => ipcRenderer.invoke('get-user-country'),
  getUserBillingAddress: () => ipcRenderer.invoke('get-user-billing-address'),
  getUserApps: () => ipcRenderer.invoke('get-user-apps'),
  updateUserBillingAddress: (billingAddress) => ipcRenderer.invoke('update-user-billing-address', billingAddress),
  updateUserPhone: (phone) => ipcRenderer.invoke('update-user-phone', phone),
  verifySudoPassword: (password) => ipcRenderer.invoke('verify-sudo-password', password),
  changePassword: (oldPassword, newPassword) => ipcRenderer.invoke('change-password', oldPassword, newPassword),
  createAccount: (accountData) => ipcRenderer.invoke('create-account', accountData),
  loginAndSync: (email, password) => ipcRenderer.invoke('login-and-sync', email, password),
  showOpenDialog: (options) => ipcRenderer.invoke('show-open-dialog', options),
  updateUserAvatar: (avatarPath) => ipcRenderer.invoke('update-user-avatar', avatarPath),
  switchTheme: (mode) => ipcRenderer.invoke('switch-theme', mode),
  backupThemeSettings: () => ipcRenderer.invoke('backup-theme-settings'),
  switchAccent: (colorName) => ipcRenderer.invoke('switch-accent', colorName),
  getAccent: () => ipcRenderer.invoke('get-accent'),
  getWallpaperColorAtPosition: (windowX, windowY, windowWidth, windowHeight) => ipcRenderer.invoke('get-wallpaper-color-at-position', windowX, windowY, windowWidth, windowHeight),
  getWindowPosition: () => ipcRenderer.invoke('get-window-position'),
  onWindowMoved: (callback) => {
    ipcRenderer.on('window-moved', (event, data) => callback(data));
  },
  removeWindowMovedListener: () => {
    ipcRenderer.removeAllListeners('window-moved');
  },
  saveTintWindowSetting: (enabled) => ipcRenderer.invoke('save-tint-window-setting', enabled),
  loadTintWindowSetting: () => ipcRenderer.invoke('load-tint-window-setting'),
  downloadPiriModel: () => ipcRenderer.invoke('download-piri-model'),
  cancelPiriDownload: () => ipcRenderer.invoke('cancel-piri-download'),
  piriModelExists: () => ipcRenderer.invoke('piri-model-exists'),
  piriModelRemove: () => ipcRenderer.invoke('piri-model-remove'),
  piriGetShowIcon: () => ipcRenderer.invoke('piri-get-show-icon'),
  piriSetShowIcon: (value) => ipcRenderer.invoke('piri-set-show-icon', value),
  onPiriDownloadProgress: (callback) => {
    ipcRenderer.on('piri-download-progress', (event, data) => callback(data));
  },
  removePiriDownloadProgress: () => {
    ipcRenderer.removeAllListeners('piri-download-progress');
  }
});


