#!/usr/bin/env python3
# Script pentru Text-to-Speech folosind edge-tts (Microsoft Edge TTS)
# Voci mai naturale și mai calde, fără cheie API, gratuit

import sys
import os

def text_to_speech(text, output_file):
    """Generează audio folosind edge-tts CLI cu voce caldă și naturală"""
    import subprocess
    
    # Voce masculină caldă și naturală (en-US-AndrewNeural)
    # Andrew este o voce masculină caldă, confidentă și naturală
    voice = "en-US-AndrewNeural"
    
    # Încearcă să folosească edge-tts CLI (din pipx)
    edge_tts_paths = [
        "edge-tts",  # Dacă este în PATH
        os.path.expanduser("~/.local/bin/edge-tts"),  # Pipx location
    ]
    
    edge_tts_cmd = None
    for path in edge_tts_paths:
        if os.path.exists(path) or path == "edge-tts":
            edge_tts_cmd = path
            break
    
    if edge_tts_cmd:
        try:
            # Folosește edge-tts CLI pentru voce caldă și naturală
            result = subprocess.run(
                [edge_tts_cmd, "--voice", voice, "--text", text, "--write-media", output_file],
                capture_output=True,
                timeout=30
            )
            if result.returncode == 0 and os.path.exists(output_file):
                return True
        except Exception:
            pass
    
    # Fallback la gTTS dacă edge-tts nu funcționează
    try:
        from gtts import gTTS
        tts = gTTS(text=text, lang='en', slow=False)
        tts.save(output_file)
        return True
    except:
        return False

def main():
    if len(sys.argv) < 2:
        return
    
    text_file = sys.argv[1]
    
    try:
        with open(text_file, 'r', encoding='utf-8') as f:
            text = f.read().strip()
        
        if text and len(text) > 0:
            output_file = '/tmp/tts_output.mp3'
            
            # Generează audio cu edge-tts (voce mai caldă și mai naturală)
            success = text_to_speech(text, output_file)
            
            if success and os.path.exists(output_file):
                # Redă audio
                os.system('mpg123 -q /tmp/tts_output.mp3 2>/dev/null || paplay /tmp/tts_output.mp3 2>/dev/null || aplay /tmp/tts_output.mp3 2>/dev/null')
                os.remove(output_file)
            
            # Șterge fișierul text temporar
            if text_file.startswith('/tmp/'):
                try:
                    os.remove(text_file)
                except:
                    pass
    except Exception:
        # Ignoră erorile în mod silențios
        pass

if __name__ == '__main__':
    main()

