#!/usr/bin/env python3
# Script simplu pentru conversie text-to-number
# Suportă numere de la 1 la 99

import sys
import re

def text_to_number(text):
    """Convertește numere scrise cu litere în cifre (1-99)"""
    text_lower = text.lower().strip()
    
    # Dicționar pentru numere (ordinea contează - numerele mai lungi trebuie să fie primele)
    number_map = [
        ('zero', 0), ('one', 1), ('two', 2), ('three', 3), ('four', 4), ('five', 5),
        ('six', 6), ('seven', 7), ('eight', 8), ('nine', 9), ('ten', 10),
        ('eleven', 11), ('twelve', 12), ('thirteen', 13), ('fourteen', 14), ('fifteen', 15),
        ('sixteen', 16), ('seventeen', 17), ('eighteen', 18), ('nineteen', 19),
        ('twenty', 20), ('thirty', 30), ('forty', 40), ('fifty', 50), ('sixty', 60),
        ('seventy', 70), ('eighty', 80), ('ninety', 90)
    ]
    
    # Caută numerele mai lungi mai întâi (sortate descrescător după lungime)
    sorted_map = sorted(number_map, key=lambda x: len(x[0]), reverse=True)
    
    # Încercă să găsească un număr direct (folosind regex pentru cuvinte întregi)
    import re
    for word, num in sorted_map:
        # Folosește regex pentru a găsi cuvântul ca un cuvânt întreg (nu substring)
        pattern = r'\b' + re.escape(word) + r'\b'
        if re.search(pattern, text_lower):
            # Verifică dacă este un număr compus (ex: "sixty-five")
            hyphen_word = word + '-'
            pattern_hyphen = r'\b' + re.escape(hyphen_word) + r'(\w+)'
            match = re.search(pattern_hyphen, text_lower)
            if match:
                # Extrage numărul de după hyphen
                second_part = match.group(1).split()[0] if match.group(1) else ''
                for w2, n2 in sorted_map:
                    if second_part.startswith(w2) and n2 < 10:
                        return num + n2
            
            return num
    
    return None

if __name__ == '__main__':
    if len(sys.argv) < 2:
        sys.exit(1)
    
    text = sys.argv[1]
    result = text_to_number(text)
    
    if result is not None:
        print(result)
        sys.exit(0)
    else:
        sys.exit(1)

