function weatherShortText(languageCode, code) {
    let descriptions = {
        en: {
            0: "Clear",
            1: "Clear",
            2: "Cloudy",
            3: "Cloudy",
            51: "Drizzle",
            53: "Drizzle",
            55: "Drizzle",
            56: "Drizzle",
            57: "Drizzle",
            61: "Rain",
            63: "Rain",
            65: "Rain",
            66: "Rain",
            67: "Rain",
            71: "Snow",
            73: "Snow",
            75: "Snow",
            77: "Hail",
            80: "Showers",
            81: "Showers",
            82: "Showers",
            85: "Showers",
            86: "Showers",
            95: "Storm",
            96: "Storm",
            99: "Storm"
        },
        es: {
            0: "Despejado",
            1: "Despejado",
            2: "Nublado",
            3: "Nublado",
            51: "Llovizna",
            53: "Llovizna",
            55: "Llovizna",
            56: "Llovizna",
            57: "Llovizna",
            61: "Lluvia",
            63: "Lluvia",
            65: "Lluvia",
            66: "Lluvia",
            67: "Lluvia",
            71: "Nieve",
            73: "Nieve",
            75: "Nieve",
            77: "Granizo",
            80: "Aguaceros",
            81: "Aguaceros",
            82: "Aguaceros",
            85: "Aguaceros",
            86: "Aguaceros",
            95: "Tormenta",
            96: "Tormenta",
            99: "Tormenta"
        },
        hi: {
            0: "साफ",
            1: "साफ",
            2: "बादल",
            3: "बादल",
            51: "बूँदा बाँदी",
            53: "बूँदा बाँदी",
            55: "बूँदा बाँदी",
            56: "बूँदा बाँदी",
            57: "बूँदा बाँदी",
            61: "वर्षा",
            63: "वर्षा",
            65: "वर्षा",
            66: "वर्षा",
            67: "वर्षा",
            71: "बर्फ",
            73: "बर्फ",
            75: "बर्फ",
            77: "ओला",
            80: "झरी",
            81: "झरी",
            82: "झरी",
            85: "झरी",
            86: "झरी",
            95: "तूफान",
            96: "तूफान",
            99: "तूफान"
        },
        fr: {
            0: "Clair",
            1: "Clair",
            2: "Nuageux",
            3: "Nuageux",
            51: "Bruine",
            53: "Bruine",
            55: "Bruine",
            56: "Bruine",
            57: "Bruine",
            61: "Pluie",
            63: "Pluie",
            65: "Pluie",
            66: "Pluie",
            67: "Pluie",
            71: "Neige",
            73: "Neige",
            75: "Neige",
            77: "Grêle",
            80: "Averses",
            81: "Averses",
            82: "Averses",
            85: "Averses",
            86: "Averses",
            95: "Tempête",
            96: "Tempête",
            99: "Tempête"
        },
        ru: {
            0: "Ясно",
            1: "Ясно",
            2: "Облачно",
            3: "Облачно",
            51: "Морось",
            53: "Морось",
            55: "Морось",
            56: "Морось",
            57: "Морось",
            61: "Дождь",
            63: "Дождь",
            65: "Дождь",
            66: "Дождь",
            67: "Дождь",
            71: "Снег",
            73: "Снег",
            75: "Снег",
            77: "Град",
            80: "Ливни",
            81: "Ливни",
            82: "Ливни",
            85: "Ливни",
            86: "Ливни",
            95: "Буря",
            96: "Буря",
            99: "Буря"
        },
        zh: {
            0: "晴朗",
            1: "晴朗",
            2: "多云",
            3: "多云",
            51: "小雨",
            53: "小雨",
            55: "小雨",
            56: "小雨",
            57: "小雨",
            61: "雨",
            63: "雨",
            65: "雨",
            66: "雨",
            67: "雨",
            71: "雪",
            73: "雪",
            75: "雪",
            77: "冰雹",
            80: "阵雨",
            81: "阵雨",
            82: "阵雨",
            85: "阵雨",
            86: "阵雨",
            95: "暴风",
            96: "暴风",
            99: "暴风"
        },
        pt: {
            0: "Claro",
            1: "Claro",
            2: "Nublado",
            3: "Nublado",
            51: "Garoa",
            53: "Garoa",
            55: "Garoa",
            56: "Garoa",
            57: "Garoa",
            61: "Chuva",
            63: "Chuva",
            65: "Chuva",
            66: "Chuva",
            67: "Chuva",
            71: "Neve",
            73: "Neve",
            75: "Neve",
            77: "Granizo",
            80: "Chuvas",
            81: "Chuvas",
            82: "Chuvas",
            85: "Chuvas",
            86: "Chuvas",
            95: "Tempestade",
            96: "Tempestade",
            99: "Tempestade"
        },
        ar: {
            0: "صافي",
            1: "صافي",
            2: "غائم",
            3: "غائم",
            51: "رذاذ",
            53: "رذاذ",
            55: "رذاذ",
            56: "رذاذ",
            57: "رذاذ",
            61: "مطر",
            63: "مطر",
            65: "مطر",
            66: "مطر",
            67: "مطر",
            71: "ثلج",
            73: "ثلج",
            75: "ثلج",
            77: "بَرَد",
            80: "زخات",
            81: "زخات",
            82: "زخات",
            85: "زخات",
            86: "زخات",
            95: "عاصفة",
            96: "عاصفة",
            99: "عاصفة"
        },
        bn: {
            0: "পরিষ্কার",
            1: "পরিষ্কার",
            2: "মেঘলা",
            3: "মেঘলা",
            51: "ঝিরঝিরি",
            53: "ঝিরঝিরি",
            55: "ঝিরঝিরি",
            56: "ঝিরঝিরি",
            57: "ঝিরঝিরি",
            61: "বৃষ্টি",
            63: "বৃষ্টি",
            65: "বৃষ্টি",
            66: "বৃষ্টি",
            67: "বৃষ্টি",
            71: "তুষার",
            73: "তুষার",
            75: "তুষার",
            77: "শিলা",
            80: "ঝরণা",
            81: "ঝরণা",
            82: "ঝরণা",
            85: "ঝরণা",
            86: "ঝরণা",
            95: "ঝড়",
            96: "ঝড়",
            99: "ঝড়"
        },
        de: {
            0: "Klar",
            1: "Klar",
            2: "Bewölkt",
            3: "Bewölkt",
            51: "Niesel",
            53: "Niesel",
            55: "Niesel",
            56: "Niesel",
            57: "Niesel",
            61: "Regen",
            63: "Regen",
            65: "Regen",
            66: "Regen",
            67: "Regen",
            71: "Schnee",
            73: "Schnee",
            75: "Schnee",
            77: "Hagel",
            80: "Schauer",
            81: "Schauer",
            82: "Schauer",
            85: "Schauer",
            86: "Schauer",
            95: "Sturm",
            96: "Sturm",
            99: "Sturm"
        },
        ja: {
            0: "晴れ",
            1: "晴れ",
            2: "曇り",
            3: "曇り",
            51: "霧雨",
            53: "霧雨",
            55: "霧雨",
            56: "霧雨",
            57: "霧雨",
            61: "雨",
            63: "雨",
            65: "雨",
            66: "雨",
            67: "雨",
            71: "雪",
            73: "雪",
            75: "雪",
            77: "ひょう",
            80: "にわか雨",
            81: "にわか雨",
            82: "にわか雨",
            85: "にわか雨",
            86: "にわか雨",
            95: "嵐",
            96: "嵐",
            99: "嵐"
        },
        ko: {
            0: "맑음",
            1: "맑음",
            2: "흐림",
            3: "흐림",
            51: "이슬비",
            53: "이슬비",
            55: "이슬비",
            56: "이슬비",
            57: "이슬비",
            61: "비",
            63: "비",
            65: "비",
            66: "비",
            67: "비",
            71: "눈",
            73: "눈",
            75: "눈",
            77: "우박",
            80: "소나기",
            81: "소나기",
            82: "소나기",
            85: "소나기",
            86: "소나기",
            95: "폭풍",
            96: "폭풍",
            99: "폭풍"
        },
        it: {
            0: "Sereno",
            1: "Sereno",
            2: "Nuvoloso",
            3: "Nuvoloso",
            51: "Pioggerella",
            53: "Pioggerella",
            55: "Pioggerella",
            56: "Pioggerella",
            57: "Pioggerella",
            61: "Pioggia",
            63: "Pioggia",
            65: "Pioggia",
            66: "Pioggia",
            67: "Pioggia",
            71: "Neve",
            73: "Neve",
            75: "Neve",
            77: "Grandine",
            80: "Rovesci",
            81: "Rovesci",
            82: "Rovesci",
            85: "Rovesci",
            86: "Rovesci",
            95: "Tempesta",
            96: "Tempesta",
            99: "Tempesta"
        }
    };

    if (descriptions[languageCode]) {
        return descriptions[languageCode][code] || "Unknown";
    } else {
        return "Language not supported";
    }
}

function weatherLongText(languageCode, code) {
    let descriptions = {
        en: {
            0: "Clear",
            1: "Mainly clear",
            2: "Partly cloudy",
            3: "Overcast",
            51: "Drizzle light intensity",
            53: "Drizzle moderate intensity",
            55: "Drizzle dense intensity",
            56: "Freezing Drizzle light intensity",
            57: "Freezing Drizzle dense intensity",
            61: "Rain slight intensity",
            63: "Rain moderate intensity",
            65: "Rain heavy intensity",
            66: "Freezing Rain light intensity",
            67: "Freezing Rain heavy intensity",
            71: "Snowfall slight intensity",
            73: "Snowfall moderate intensity",
            75: "Snowfall heavy intensity",
            77: "Snow grains",
            80: "Rain showers slight",
            81: "Rain showers moderate",
            82: "Rain showers violent",
            85: "Snow showers slight",
            86: "Snow showers heavy",
            95: "Thunderstorm",
            96: "Thunderstorm with slight hail",
            99: "Thunderstorm with heavy hail"
        },
        es: {
            0: "Despejado",
            1: "Mayormente despejado",
            2: "Parcialmente nublado",
            3: "Nublado",
            51: "Llovizna de baja intensidad",
            53: "Llovizna de intensidad moderada",
            55: "Llovizna de intensidad densa",
            56: "Llovizna helada de baja intensidad",
            57: "Llovizna helada de intensidad densa",
            61: "Lluvia de ligera intensidad",
            63: "Lluvia de intensidad moderada",
            65: "Lluvia de intensidad fuerte",
            66: "Lluvia helada de baja intensidad",
            67: "Lluvia helada de alta intensidad",
            71: "Nieve de ligera intensidad",
            73: "Nieve de intensidad moderada",
            75: "Nieve de intensidad fuerte",
            77: "Granizo",
            80: "Aguaceros de lluvia de ligera intensidad",
            81: "Aguaceros de lluvia de intensidad moderada",
            82: "Aguaceros de lluvia de intensidad violenta",
            85: "Aguaceros de nieve de ligera intensidad",
            86: "Aguaceros de nieve de intensidad fuerte",
            95: "Tormenta",
            96: "Tormenta con granizo ligero",
            99: "Tormenta con granizo fuerte"
        },
        fr: {
            0: "Clair",
            1: "Partiellement clair",
            2: "Partiellement nuageux",
            3: "Couvert",
            51: "Bruine légère",
            53: "Bruine modérée",
            55: "Bruine dense",
            56: "Bruine verglaçante légère",
            57: "Bruine verglaçante dense",
            61: "Pluie légère",
            63: "Pluie modérée",
            65: "Pluie forte",
            66: "Pluie verglaçante légère",
            67: "Pluie verglaçante forte",
            71: "Légère chute de neige",
            73: "Chute de neige modérée",
            75: "Chute de neige forte",
            77: "Grains de neige",
            80: "Averses de pluie légères",
            81: "Averses de pluie modérées",
            82: "Averses de pluie violentes",
            85: "Averses de neige légères",
            86: "Averses de neige fortes",
            95: "Orage",
            96: "Orage avec grêle légère",
            99: "Orage avec grêle forte"
        },
        de: {
            0: "Klar",
            1: "Überwiegend klar",
            2: "Teilweise bewölkt",
            3: "Bedeckt",
            51: "Leichter Nieselregen",
            53: "Mäßiger Nieselregen",
            55: "Dichter Nieselregen",
            56: "Leichter Gefrierender Nieselregen",
            57: "Dichter Gefrierender Nieselregen",
            61: "Leichter Regen",
            63: "Mäßiger Regen",
            65: "Starker Regen",
            66: "Leichter Gefrierender Regen",
            67: "Starker Gefrierender Regen",
            71: "Leichter Schneefall",
            73: "Mäßiger Schneefall",
            75: "Starker Schneefall",
            77: "Schneekörner",
            80: "Leichte Regenschauer",
            81: "Mäßige Regenschauer",
            82: "Starker Regenschauer",
            85: "Leichte Schneeschauer",
            86: "Starke Schneeschauer",
            95: "Gewitter",
            96: "Gewitter mit leichtem Hagel",
            99: "Gewitter mit starkem Hagel"
        },
        it: {
            0: "Sereno",
            1: "Prevalentemente sereno",
            2: "Parzialmente nuvoloso",
            3: "Nuvoloso",
            51: "Pioviggine debole",
            53: "Pioviggine moderata",
            55: "Pioviggine intensa",
            56: "Pioviggine ghiacciata debole",
            57: "Pioviggine ghiacciata intensa",
            61: "Pioggia debole",
            63: "Pioggia moderata",
            65: "Pioggia intensa",
            66: "Pioggia ghiacciata debole",
            67: "Pioggia ghiacciata intensa",
            71: "Nevicata debole",
            73: "Nevicata moderata",
            75: "Nevicata intensa",
            77: "Granuli di neve",
            80: "Pioggia debole con rovesci",
            81: "Pioggia moderata con rovesci",
            82: "Pioggia intensa con rovesci",
            85: "Nevicata debole con rovesci",
            86: "Nevicata intensa con rovesci",
            95: "Temporale",
            96: "Temporale con grandine leggera",
            99: "Temporale con grandine forte"
        },
        pt: {
            0: "Céu limpo",
            1: "Céu pouco nublado",
            2: "Parcialmente nublado",
            3: "Céu nublado",
            51: "Chuviscos de fraca intensidade",
            53: "Chuviscos de intensidade moderada",
            55: "Chuviscos de intensidade forte",
            56: "Chuviscos congelantes de fraca intensidade",
            57: "Chuviscos congelantes de intensidade forte",
            61: "Chuva de fraca intensidade",
            63: "Chuva de intensidade moderada",
            65: "Chuva de intensidade forte",
            66: "Chuva congelante de fraca intensidade",
            67: "Chuva congelante de intensidade forte",
            71: "Queda de neve de fraca intensidade",
            73: "Queda de neve de intensidade moderada",
            75: "Queda de neve de intensidade forte",
            77: "Granulado de neve",
            80: "Aguaceiros de chuva fracos",
            81: "Aguaceiros de chuva moderados",
            82: "Aguaceiros de chuva fortes",
            85: "Aguaceiros de neve fracos",
            86: "Aguaceiros de neve fortes",
            95: "Trovoada",
            96: "Trovoada com granizo fraco",
            99: "Trovoada com granizo forte"
        },
        ja: {
            0: "晴れ",
            1: "大部分晴れ",
            2: "一部曇り",
            3: "曇り",
            51: "わずかな霧雨",
            53: "穏やかな霧雨",
            55: "濃い霧雨",
            56: "軽い凍雨",
            57: "濃い凍雨",
            61: "弱い雨",
            63: "穏やかな雨",
            65: "激しい雨",
            66: "軽い着氷性の雨",
            67: "激しい着氷性の雨",
            71: "弱い雪",
            73: "穏やかな雪",
            75: "激しい雪",
            77: "雪の粒",
            80: "弱いにわか雨",
            81: "穏やかなにわか雨",
            82: "激しいにわか雨",
            85: "弱いにわか雪",
            86: "激しいにわか雪",
            95: "雷雨",
            96: "軽い雹を伴う雷雨",
            99: "激しい雹を伴う雷雨"
        },
        ru: {
            0: "Ясно",
            1: "В основном ясно",
            2: "Частично облачно",
            3: "Пасмурно",
            51: "Морось слабая интенсивность",
            53: "Морось умеренная интенсивность",
            55: "Морось плотная интенсивность",
            56: "Ледяной дождь слабой интенсивности",
            57: "Ледяной дождь сильной интенсивности",
            61: "Дождь слабой интенсивности",
            63: "Дождь умеренной интенсивности",
            65: "Дождь сильной интенсивности",
            66: "Ледяной дождь слабой интенсивности",
            67: "Ледяной дождь сильной интенсивности",
            71: "Снег слабой интенсивности",
            73: "Снег умеренной интенсивности",
            75: "Снег сильной интенсивности",
            77: "Снежные зерна",
            80: "Дождь с прояснениями слабый",
            81: "Дождь с прояснениями умеренный",
            82: "Дождь с прояснениями сильный",
            85: "Снег с прояснениями слабый",
            86: "Снег с прояснениями сильный",
            95: "Гроза",
            96: "Гроза с небольшим градом",
            99: "Гроза с сильным градом"
        },
        zh: {
            0: "晴",
            1: "晴间多云",
            2: "局部多云",
            3: "阴天",
            51: "小雨",
            53: "中雨",
            55: "大雨",
            56: "小冻雨",
            57: "大冻雨",
            61: "小雨夹雪",
            63: "中雨夹雪",
            65: "大雨夹雪",
            66: "小冰雨",
            67: "大冰雨",
            71: "小雪",
            73: "中雪",
            75: "大雪",
            77: "雪粒",
            80: "小雨 showers",
            81: "中雨 showers",
            82: "大雨 showers",
            85: "小雪 showers",
            86: "大雪 showers",
            95: "雷暴",
            96: "雷暴并伴有小冰雹",
            99: "雷暴并伴有大冰雹"
        },
        ko: {
            0: "맑음",
            1: "구름 조금",
            2: "부분적으로 흐림",
            3: "흐림",
            51: "약한 이슬비",
            53: "중간 강도의 이슬비",
            55: "짙은 이슬비",
            56: "약한 동결 이슬비",
            57: "강한 동결 이슬비",
            61: "약한 비",
            63: "중간 강도의 비",
            65: "강한 비",
            66: "약한 동결 비",
            67: "강한 동결 비",
            71: "약한 눈",
            73: "중간 강도의 눈",
            75: "강한 눈",
            77: "눈송이",
            80: "약한 비 샤워",
            81: "중간 강도의 비 샤워",
            82: "강한 비 샤워",
            85: "약한 눈 샤워",
            86: "강한 눈 샤워",
            95: "천둥 번개",
            96: "약한 우박을 동반한 천둥 번개",
            99: "강한 우박을 동반한 천둥 번개"
        },
        // Agrega más idiomas aquí según sea necesario
    };

    if (descriptions[languageCode]) {
        return descriptions[languageCode][code] || "Unknown";
    } else {
        return "Language not supported";
    }
}
function rainProbabilityText(languageCode) {
    const translations = {
        es: "Probabilidad de lluvia",         // Spanish
        "en": "Probability of rain",            // English
        "hi": "बारिश की संभावना",            // Hindi
        "fr": "Probabilité de pluie",             // French
        "de": "Regenwahrscheinlichkeit",       // German
        "it": "Probabilità di pioggia",          // Italian
        "pt": "Probabilidade de chuva",   // Portuguese
        "ru": "Вероятность дождя",               // Russian
        "zh": "降雨概率",                // Chinese (Mandarin)
        "ja": "降雨確率",         // Japanese
        "ko": "비 올 확률",            // Korean
        "nl": "Regenkans",          // Dutch
        "ny": "Mwayi wamagulu"           // Chichewa
    };

    // Return the translation for the language code or default to English if not found
    return translations[languageCode] || translations["en"];
}

function lavelUV(languageCode, lavel) {
    const translations = {
        es: {
            0: "Bajo",
            1: "Moderado",
            2: "Alto",
            3: "Muy Alto",
            4: "Extremo"
        },
        en: {
            0: "Low",
            1: "Moderate",
            2: "High",
            3: "Very High",
            4: "Extreme"
        },
        hi: {
            0: "कम",
            1: "मध्यम",
            2: "उच्च",
            3: "बहुत उच्च",
            4: "अत्यधिक"
        },
        fr: {
            0: "Faible",
            1: "Modéré",
            2: "Élevé",
            3: "Très Élevé",
            4: "Extrême"
        },
        de: {
            0: "Niedrig",
            1: "Mäßig",
            2: "Hoch",
            3: "Sehr Hoch",
            4: "Extrem"
        },
        it: {
            0: "Basso",
            1: "Moderato",
            2: "Alto",
            3: "Molto Alto",
            4: "Estremo"
        },
        pt: {
            0: "Baixo",
            1: "Moderado",
            2: "Alto",
            3: "Muito Alto",
            4: "Extremo"
        },
        ru: {
            0: "Низкий",
            1: "Умеренный",
            2: "Высокий",
            3: "Очень Высокий",
            4: "Экстремальный"
        },
        zh: {
            0: "低",
            1: "中等",
            2: "高",
            3: "很高",
            4: "极高"
        },
        ja: {
            0: "低い",
            1: "中程度",
            2: "高い",
            3: "非常に高い",
            4: "極端"
        },
        ko: {
            0: "낮음",
            1: "보통",
            2: "높음",
            3: "매우 높음",
            4: "극심함"
        },
        nl: {
            0: "Laag",
            1: "Matig",
            2: "Hoog",
            3: "Zeer Hoog",
            4: "Extreem"
        },
        ny: {
            0: "Zochepa",
            1: "Apakatikati",
            2: "Wapamwamba",
            3: "Wapamwamba Kwambiri",
            4: "Mowopsa"
        }
    };

    // Return the translation for the language code or default to English if not found
    if (translations[languageCode]) {
        return translations[languageCode][lavel] || "Unknown";
    } else {
        return "Language not supported";
    }
}

function windSpeedText(languageCode) {
    const translations = {
        "es": "Velocidad del viento",
        "en": "Wind Speed",
        "hi": "हवा की गति",
        "fr": "Vitesse du vent",
        "de": "Windgeschwindigkeit",
        "it": "Velocità del vento",
        "pt": "Velocidade do vento",
        "ru": "Скорость ветра",
        "zh": "风速",
        "ja": "風速",
        "ko": "풍속",
        "nl": "Windsnelheid",
        "ny": "Zachitentha"
    };

    const shortTranslations = {
        "es": "Viento",
        "en": "Wind",
        "hi": "हवा",
        "fr": "Vent",
        "de": "Wind",
        "it": "Vento",
        "pt": "Vento",
        "ru": "Ветер",
        "zh": "风",
        "ja": "風",
        "ko": "바람",
        "nl": "Wind",
        "ny": "Mphepo"
    };

    // Get the full translation or default to English if not found
    const fullTranslation = translations[languageCode] || translations["en"];

    // Return the short translation if the full one is longer than 15 characters
    if (fullTranslation.length > 15) {
        return shortTranslations[languageCode] || shortTranslations["en"];
    }

    return fullTranslation;
}

function uvRadiationText(languageCode) {
    const translations = {
        "es": "UV",
        "en": "UV",
        "hi": "यूवी विकिरण",
        "fr": "UV",
        "de": "UV",
        "it": "UV",
        "pt": "UV",
        "ru": "УФ-излучение",
        "zh": "紫外线辐射",
        "ja": "UV",
        "ko": "자외선 방사",
        "nl": "UV",
        "ny": "UV"
    };

    // Return the translation for the language code or default to "UV" if not found
    return translations[languageCode] || "UV";
}
