/*
    SPDX-FileCopyrightText: 2016 David Edmundson
    Adapted for pearOS

    SPDX-License-Identifier: LGPL-2.0-or-later
*/
import QtQuick
import QtQuick.Layouts
import QtQuick.Controls

ColumnLayout {
    spacing: 2

    FontLoader {
        id: fontbold
        source: Qt.resolvedUrl("../../fonts/SFUIText-Semibold.otf")
    }
    readonly property bool softwareRendering: GraphicsInfo.api === GraphicsInfo.Software
    property date currentTime: new Date()

    Timer {
        interval: 1000
        running: true
        repeat: true
        onTriggered: currentTime = new Date()
    }

    Label {
        text: Qt.formatDateTime(currentTime, "ddd MMM d")
        color: "white"
        opacity: 0.5
        style: softwareRendering ? Text.Outline : Text.Normal
        styleColor: softwareRendering ? "black" : "transparent"
        font.pointSize: 20
        font.weight: Font.DemiBold
        font.capitalization: Font.Capitalize
        Layout.alignment: Qt.AlignHCenter
        font.family: fontbold.name
    }
    Label {
        text: Qt.formatDateTime(currentTime, "hh:mm")
        color: "white"
        opacity: 0.5
        style: softwareRendering ? Text.Outline : Text.Normal
        styleColor: softwareRendering ? "black" : "transparent"
        font.pointSize: 100
        font.bold: true
        Layout.alignment: Qt.AlignHCenter
        font.family: fontbold.name
    }
}
